<p data-nodeid="196607" class="">我们在上一课时，了解到可以使用 ThreadLocal，来避免 SimpleDateFormat 在并发环境下引起的时间错乱问题。其实还有一种解决方式，就是通过对<strong data-nodeid="196809">parse 方法</strong>进行加锁，也能保证日期处理类的正确运行，代码如下图（可见<a href="https://gitee.com/xjjdog/tuning-lagou-res/tree/master/tuning-011/design-pattern" data-nodeid="196807">仓库</a>）：</p>
<p data-nodeid="196608"><img src="https://s0.lgstatic.com/i/image/M00/45/BD/Ciqc1F9DbU6AeoPsAAC8Nn863qc911.png" alt="Drawing 0.png" data-nodeid="196812"></p>
<p data-nodeid="196609">其实锁对性能的影响，是非常大的。因为对资源加锁以后，资源就被加锁的线程独占，其他的线程就只能排队等待这个锁，此时程序由并行执行，变相地成了顺序执行，执行速度自然就降低了。</p>
<p data-nodeid="196610">下面是开启了 50 个线程，使用 ThreadLocal 和同步锁方式性能的一个对比。</p>
<pre class="lang-java" data-nodeid="196611"><code data-language="java">Benchmark &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Mode &nbsp;Cnt &nbsp; &nbsp; Score &nbsp; &nbsp; &nbsp;Error &nbsp; Units
SynchronizedNormalBenchmark.sync &nbsp; &nbsp; &nbsp; &nbsp; thrpt &nbsp; <span class="hljs-number">10</span> &nbsp;<span class="hljs-number">2554.628</span> ± <span class="hljs-number">5098.059</span> &nbsp;ops/ms
SynchronizedNormalBenchmark.threadLocal &nbsp;thrpt &nbsp; <span class="hljs-number">10</span> &nbsp;<span class="hljs-number">3750.902</span> ± &nbsp;<span class="hljs-number">103.528</span> &nbsp;ops/ms
========去掉业务影响========
Benchmark &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Mode &nbsp;Cnt &nbsp; &nbsp; &nbsp; &nbsp;Score &nbsp; &nbsp; &nbsp; &nbsp;Error &nbsp; Units
SynchronizedNormalBenchmark.sync &nbsp; &nbsp; &nbsp; &nbsp; thrpt &nbsp; <span class="hljs-number">10</span> &nbsp; &nbsp;<span class="hljs-number">26905.514</span> ± &nbsp; <span class="hljs-number">1688.600</span> &nbsp;ops/ms
SynchronizedNormalBenchmark.threadLocal &nbsp;thrpt &nbsp; <span class="hljs-number">10</span> &nbsp;<span class="hljs-number">7041876.244</span> ± <span class="hljs-number">355598.686</span> &nbsp;ops/ms
</code></pre>
<p data-nodeid="196612">可以看到，使用同步锁的方式，性能是比较低的。如果去掉业务本身逻辑的影响（删掉执行逻辑），这个差异会更大。代码执行的次数越多，锁的累加影响越大，对锁本身的速度优化，是非常重要的。</p>
<p data-nodeid="196613">我们都知道，Java 中有两种加锁的方式：一种就是常见的<strong data-nodeid="196825">synchronized 关键字</strong>，另外一种，就是<strong data-nodeid="196826">使用 concurrent 包里面的 Lock</strong>。针对这两种锁，JDK 自身做了很多的优化，它们的实现方式也是不同的。本课时将从这两种锁讲起，看一下对锁的一些优化方式。</p>
<h3 data-nodeid="196614">synchronied</h3>
<p data-nodeid="196615">synchronized 关键字给代码或者方法上锁时，都有显示或者隐藏的上锁对象。当一个线程试图<strong data-nodeid="196841">访问同步代码块</strong>时，它首先必须得到锁，而<strong data-nodeid="196842">退出</strong>或<strong data-nodeid="196843">抛出异常</strong>时必须释放锁。</p>
<ul data-nodeid="196616">
<li data-nodeid="196617">
<p data-nodeid="196618">给普通方法加锁时，上锁的对象是 this；</p>
</li>
<li data-nodeid="196619">
<p data-nodeid="196620">给静态方法加锁时，锁的是 class 对象；</p>
</li>
<li data-nodeid="196621">
<p data-nodeid="196622">给代码块加锁，可以指定一个具体的对象作为锁。</p>
</li>
</ul>
<h4 data-nodeid="196623">1.monitor 原理</h4>
<p data-nodeid="196624"><strong data-nodeid="196852">在面试中，面试官很可能会问你：synchronized 在字节码中，是怎么体现的呢？</strong> 参照下面的代码，在命令行执行 javac，然后再执行 javap -v -p，就可以看到它具体的字节码。</p>
<p data-nodeid="196625">可以看到，在字节码的体现上，它只给方法加了一个 flag：ACC_SYNCHRONIZED。</p>
<pre class="lang-dart" data-nodeid="196626"><code data-language="dart">synchronized <span class="hljs-keyword">void</span> syncMethod() {
        System.out.println(<span class="hljs-string">"syncMethod"</span>);
}
======字节码=====
synchronized <span class="hljs-keyword">void</span> syncMethod();
 &nbsp; &nbsp;descriptor: ()V
 &nbsp; &nbsp;flags: ACC_SYNCHRONIZED
 &nbsp; &nbsp;Code:
 &nbsp; &nbsp; &nbsp;stack=<span class="hljs-number">2</span>, locals=<span class="hljs-number">1</span>, args_size=<span class="hljs-number">1</span>
 &nbsp; &nbsp; &nbsp; &nbsp; <span class="hljs-number">0</span>: getstatic &nbsp; &nbsp; #<span class="hljs-number">4</span>
 &nbsp; &nbsp; &nbsp; &nbsp; <span class="hljs-number">3</span>: ldc &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; #<span class="hljs-number">5</span>
 &nbsp; &nbsp; &nbsp; &nbsp; <span class="hljs-number">5</span>: invokevirtual #<span class="hljs-number">6</span>
 &nbsp; &nbsp; &nbsp; &nbsp; <span class="hljs-number">8</span>: <span class="hljs-keyword">return</span>
</code></pre>
<p data-nodeid="196627">我们再来看下同步代码块的字节码。可以看到，字节码是通过 monitorenter 和monitorexit 两个指令进行控制的。</p>
<pre class="lang-dart" data-nodeid="196628"><code data-language="dart"><span class="hljs-keyword">void</span> syncBlock(){
 &nbsp; &nbsp;synchronized (Test.<span class="hljs-keyword">class</span>){
 &nbsp;  }
}
======字节码======
<span class="hljs-keyword">void</span> syncBlock();
 &nbsp; &nbsp;descriptor: ()V
 &nbsp; &nbsp;flags:
 &nbsp; &nbsp;Code:
 &nbsp; &nbsp; &nbsp;stack=<span class="hljs-number">2</span>, locals=<span class="hljs-number">3</span>, args_size=<span class="hljs-number">1</span>
 &nbsp; &nbsp; &nbsp; &nbsp; <span class="hljs-number">0</span>: ldc &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; #<span class="hljs-number">2</span> 
 &nbsp; &nbsp; &nbsp; &nbsp; <span class="hljs-number">2</span>: dup
 &nbsp; &nbsp; &nbsp; &nbsp; <span class="hljs-number">3</span>: astore_1
 &nbsp; &nbsp; &nbsp; &nbsp; <span class="hljs-number">4</span>: monitorenter
 &nbsp; &nbsp; &nbsp; &nbsp; <span class="hljs-number">5</span>: aload_1
 &nbsp; &nbsp; &nbsp; &nbsp; <span class="hljs-number">6</span>: monitorexit
 &nbsp; &nbsp; &nbsp; &nbsp; <span class="hljs-number">7</span>: goto &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-number">15</span>
 &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-number">10</span>: astore_2
 &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-number">11</span>: aload_1
 &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-number">12</span>: monitorexit
 &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-number">13</span>: aload_2
 &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-number">14</span>: athrow
 &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-number">15</span>: <span class="hljs-keyword">return</span>
 &nbsp; &nbsp; &nbsp;Exception table:
 &nbsp; &nbsp; &nbsp; &nbsp; from &nbsp; &nbsp;to &nbsp;target type
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <span class="hljs-number">5</span> &nbsp; &nbsp; <span class="hljs-number">7</span> &nbsp; &nbsp;<span class="hljs-number">10</span> &nbsp; any
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-number">10</span> &nbsp; &nbsp;<span class="hljs-number">13</span> &nbsp; &nbsp;<span class="hljs-number">10</span> &nbsp; any
</code></pre>
<p data-nodeid="196629">这两者虽然显示效果不同，但他们都是通过 monitor 来实现同步的。我们可以通过下面这张图，来看一下 monitor 的原理。</p>
<p data-nodeid="197586"><strong data-nodeid="197591">注意了，下面是面试题目高发地。比如，你能描述一下 monitor 锁的实现原理吗？</strong></p>
<p data-nodeid="198577"><img src="https://s0.lgstatic.com/i/image/M00/45/E9/CgqCHl9Dl-mAHYlWAACjjjqUdwE492.png" alt="1.png" data-nodeid="198580"></p>





<p data-nodeid="196632">如上图所示，我们可以把运行时的对象锁抽象地分成三部分。其中，EntrySet 和 WaitSet 是两个队列，中间虚线部分是当前持有锁的线程，我们可以想象一下线程的执行过程。</p>
<p data-nodeid="196633">当第一个线程到来时，发现并没有线程持有对象锁，它会直接成为活动线程，进入 RUNNING 状态。</p>
<p data-nodeid="196634">接着又来了三个线程，要争抢对象锁。此时，这三个线程发现锁已经被占用了，就先进入 EntrySet 缓存起来，进入 BLOCKED 状态。此时，从 jstack 命令，可以看到他们展示的信息都是 waiting for monitor entry。</p>
<pre class="lang-go" data-nodeid="196635"><code data-language="go"><span class="hljs-string">"http-nio-8084-exec-120"</span> #<span class="hljs-number">143</span> daemon prio=<span class="hljs-number">5</span> os_prio=<span class="hljs-number">31</span> cpu=<span class="hljs-number">122.86</span>ms elapsed=<span class="hljs-number">317.88</span>s tid=<span class="hljs-number">0x00007fedd8381000</span> nid=<span class="hljs-number">0x1af03</span> waiting <span class="hljs-keyword">for</span> monitor entry  [<span class="hljs-number">0x00007000150e1000</span>]
 &nbsp; java.lang.Thread.State: BLOCKED (on object monitor)
 &nbsp;  at java.io.BufferedInputStream.read(java.base@<span class="hljs-number">13.0</span><span class="hljs-number">.1</span>/BufferedInputStream.java:<span class="hljs-number">263</span>)
 &nbsp; &nbsp;- waiting to lock &lt;<span class="hljs-number">0x0000000782e1b590</span>&gt; (a java.io.BufferedInputStream)
 &nbsp;  at org.apache.commons.httpclient.HttpParser.readRawLine(HttpParser.java:<span class="hljs-number">78</span>)
 &nbsp;  at org.apache.commons.httpclient.HttpParser.readLine(HttpParser.java:<span class="hljs-number">106</span>)
 &nbsp;  at org.apache.commons.httpclient.HttpConnection.readLine(HttpConnection.java:<span class="hljs-number">1116</span>)
 &nbsp;  at org.apache.commons.httpclient.HttpMethodBase.readStatusLine(HttpMethodBase.java:<span class="hljs-number">1973</span>)
 &nbsp;  at org.apache.commons.httpclient.HttpMethodBase.readResponse(HttpMethodBase.java:<span class="hljs-number">1735</span>)
</code></pre>
<p data-nodeid="196636">处于活动状态的线程，执行完毕退出了；或者由于某种原因执行了 wait 方法，释放了对象锁，进入了 WaitSet 队列，这就是在调用 wait 之前，需要先获得对象锁的原因。</p>
<p data-nodeid="196637">就像下面的代码：</p>
<pre class="lang-java" data-nodeid="196638"><code data-language="java"><span class="hljs-keyword">synchronized</span> (lock){
 &nbsp; &nbsp;<span class="hljs-keyword">try</span> {
 &nbsp; &nbsp; &nbsp; &nbsp; lock.wait();
 &nbsp;  } <span class="hljs-keyword">catch</span> (InterruptedException e) {
 &nbsp; &nbsp; &nbsp; &nbsp;e.printStackTrace();
 &nbsp;  }
}
</code></pre>
<p data-nodeid="196639">此时，jstack 显示的线程状态是 WAITING 状态，而原因是 in Object.wait()。</p>
<pre class="lang-dart" data-nodeid="196640"><code data-language="dart"><span class="hljs-string">"wait-demo"</span> #<span class="hljs-number">12</span> prio=<span class="hljs-number">5</span> os_prio=<span class="hljs-number">31</span> cpu=<span class="hljs-number">0.14</span>ms elapsed=<span class="hljs-number">12.58</span>s tid=<span class="hljs-number">0x00007fb66609e000</span> nid=<span class="hljs-number">0x6103</span> <span class="hljs-keyword">in</span> <span class="hljs-built_in">Object</span>.wait()  [<span class="hljs-number">0x000070000f2bd000</span>]
 &nbsp; java.lang.Thread.State: WAITING (<span class="hljs-keyword">on</span> object monitor)
 &nbsp;  at java.lang.<span class="hljs-built_in">Object</span>.wait(java.base@<span class="hljs-number">13.0</span><span class="hljs-number">.1</span>/Native Method)
 &nbsp; &nbsp;- waiting <span class="hljs-keyword">on</span> &lt;<span class="hljs-number">0x0000000787b48300</span>&gt; (a java.lang.<span class="hljs-built_in">Object</span>)
 &nbsp;  at java.lang.<span class="hljs-built_in">Object</span>.wait(java.base@<span class="hljs-number">13.0</span><span class="hljs-number">.1</span>/<span class="hljs-built_in">Object</span>.java:<span class="hljs-number">326</span>)
 &nbsp;  at WaitDemo.lambda$main$<span class="hljs-number">0</span>(WaitDemo.java:<span class="hljs-number">7</span>)
 &nbsp; &nbsp;- locked &lt;<span class="hljs-number">0x0000000787b48300</span>&gt; (a java.lang.<span class="hljs-built_in">Object</span>)
 &nbsp;  at WaitDemo$$Lambda$<span class="hljs-number">14</span>/<span class="hljs-number">0x0000000800b44840</span>.run(Unknown Source)
 &nbsp;  at java.lang.Thread.run(java.base@<span class="hljs-number">13.0</span><span class="hljs-number">.1</span>/Thread.java:<span class="hljs-number">830</span>)
</code></pre>
<p data-nodeid="196641">发生了这两种情况，都会造成对象锁的释放，进而导致 EntrySet 里的线程重新争抢对象锁，成功抢到锁的线程成为活动线程，这是一个循环的过程。</p>
<p data-nodeid="196642">那 WaitSet 中的线程是如何再次被激活的呢？接下来，在某个地方，执行了锁的 notify 或者 notifyAll 命令，会造成 WaitSet 中的线程，转移到 EntrySet 中，重新进行锁的争夺。</p>
<p data-nodeid="196643">如此周而复始，线程就可按顺序排队执行。</p>
<h4 data-nodeid="196644">2.分级锁</h4>
<p data-nodeid="196645">在 JDK 1.8 中，synchronized 的速度已经有了显著的提升，它都做了哪些优化呢？答案就是分级锁。JVM 会根据使用情况，对 synchronized 的锁，进行升级，它大体可以按照下面的路径进行升级：偏向锁 — 轻量级锁 — 重量级锁。</p>
<p data-nodeid="196646"><strong data-nodeid="196880">锁只能升级，不能降级</strong>，所以一旦升级为重量级锁，就只能依靠操作系统进行调度。</p>
<p data-nodeid="196647">要想了解锁升级的过程，需要先看一下对象在内存里的结构。</p>
<p data-nodeid="201028"><img src="https://s0.lgstatic.com/i/image/M00/45/DE/Ciqc1F9Dl_uAUOqvAABFvlyPAbE897.png" alt="2.png" data-nodeid="201031"></p>


<p data-nodeid="199552">如上图所示，对象分为 MarkWord、Class Pointer、Instance Data、Padding 四个部分。</p>


<p data-nodeid="196650">和锁升级关系最大的就是 MarkWord，它的长度是 24 位，我们着重介绍一下。它包含Thread ID（23bit）、Age（6bit）、Biased（1bit）、Tag（2bit） 四个部分，锁升级就是靠判断 Thread Id、Biased、Tag 等三个变量值来进行的。</p>
<ul data-nodeid="196651">
<li data-nodeid="196652">
<p data-nodeid="196653"><strong data-nodeid="196890">偏向锁</strong></p>
</li>
</ul>
<p data-nodeid="196654">在只有一个线程使用了锁的情况下，偏向锁能够保证更高的效率。</p>
<p data-nodeid="196655">具体过程是这样的：当第一个线程第一次访问同步块时，会先检测对象头 Mark Word 中的标志位 Tag 是否为 01，以此判断此时对象锁是否处于无锁状态或者偏向锁状态（匿名偏向锁）。</p>
<p data-nodeid="196656">01 也是锁默认的状态，线程一旦获取了这把锁，就会把自己的线程 ID 写到 MarkWord 中，在其他线程来获取这把锁之前，锁都处于偏向锁状态。</p>
<p data-nodeid="196657">当下一个线程参与到偏向锁竞争时，会先判断 MarkWord 中保存的线程 ID 是否与这个线程 ID 相等，<strong data-nodeid="196899">如果不相等，会立即撤销偏向锁，升级为轻量级锁</strong>。</p>
<ul data-nodeid="196658">
<li data-nodeid="196659">
<p data-nodeid="196660"><strong data-nodeid="196903">轻量级锁</strong></p>
</li>
</ul>
<p data-nodeid="196661">轻量级锁的获取是怎么进行的呢？它们使用的是自旋方式。</p>
<p data-nodeid="196662">参与竞争的每个线程，会在自己的线程栈中生成一个 LockRecord ( LR )，然后每个线程通过 CAS（自旋）的方式，将锁对象头中的 MarkWord 设置为指向自己的 LR 的指针，哪个线程设置成功，就意味着哪个线程获得锁。</p>
<p data-nodeid="196663">当锁处于轻量级锁的状态时，就不能够再通过简单地对比 Tag 的值进行判断，每次对锁的获取，都需要通过自旋。</p>
<p data-nodeid="196664">当然，自旋也是面向不存在锁竞争的场景，比如一个线程运行完了，另外一个线程去获取这把锁；<strong data-nodeid="196912">但如果自旋失败达到一定的次数，锁就会膨胀为重量级锁</strong>。</p>
<ul data-nodeid="196665">
<li data-nodeid="196666">
<p data-nodeid="196667"><strong data-nodeid="196916">重量级锁</strong></p>
</li>
</ul>
<p data-nodeid="196668">重量级锁，即我们对 synchronized 的直观认识，这种情况下，线程会挂起，进入到操作系统内核态，等待操作系统的调度，然后再映射回用户态。系统调用是昂贵的，所以重量级锁的名称由此而来。</p>
<p data-nodeid="196669">如果系统的共享变量竞争非常激烈，锁会迅速膨胀到重量级锁，这些优化就名存实亡。如果并发非常严重，可以通过参数 -XX:-UseBiasedLocking 禁用偏向锁，理论上会有一些性能提升，但实际上并不确定。</p>
<h3 data-nodeid="196670">Lock</h3>
<p data-nodeid="196671">在 concurrent 包里，我们能够发现 ReentrantLock 和 ReentrantReadWriteLock 两个类。Reentrant 就是可重入的意思，它们和 synchronized 关键字一样，都是可重入锁。</p>
<p data-nodeid="196672">这里有必要解释一下**“可重入”这个概念，这是一个面试高频考点**。它的意思是，一个线程运行时，可以多次获取同一个对象锁，这是因为 Java 的锁是基于线程的，而不是基于调用的。</p>
<p data-nodeid="196673">比如下面这段代码，由于方法 a、b、c 锁的都是当前的 this，线程在调用 a 方法的时候，就不需要多次获取对象锁。</p>
<pre class="lang-java" data-nodeid="196674"><code data-language="java"><span class="hljs-function"><span class="hljs-keyword">public</span> <span class="hljs-keyword">synchronized</span> <span class="hljs-keyword">void</span> <span class="hljs-title">a</span><span class="hljs-params">()</span></span>{
 &nbsp; &nbsp;b();
}
<span class="hljs-function"><span class="hljs-keyword">public</span> <span class="hljs-keyword">synchronized</span> <span class="hljs-keyword">void</span> <span class="hljs-title">b</span><span class="hljs-params">()</span></span>{
 &nbsp; &nbsp;c();
}
<span class="hljs-function"><span class="hljs-keyword">public</span> <span class="hljs-keyword">synchronized</span> <span class="hljs-keyword">void</span> <span class="hljs-title">c</span><span class="hljs-params">()</span></span>{
}
</code></pre>
<h4 data-nodeid="196675">1.主要方法</h4>
<p data-nodeid="196676">Lock 是基于 AQS（AbstractQueuedSynchronizer）实现的，而 AQS 是基于 volitale 和 CAS 实现的（关于CAS，我们将在下一课时讲解）。</p>
<p data-nodeid="196677">Lock 与 synchronized 的使用方法不同，它需要手动加锁，然后在 finally 中解锁。Lock 接口比 synchronized 灵活性要高，我们来看一下几个关键方法。</p>
<ul data-nodeid="196678">
<li data-nodeid="196679">
<p data-nodeid="196680"><strong data-nodeid="196936">Lock：</strong> Lock 方法和 synchronized 没什么区别，如果获取不到锁，都会被阻塞；</p>
</li>
<li data-nodeid="196681">
<p data-nodeid="196682"><strong data-nodeid="196941">tryLock：</strong> 此方法会尝试获取锁，不管能不能获取到锁，都会立即返回，不会阻塞，它是有返回值的，获取到锁就会返回 true；</p>
</li>
<li data-nodeid="196683">
<p data-nodeid="196684"><strong data-nodeid="196946">tryLock(long time, TimeUnit unit)：</strong> 与 tryLock 类似，但它在拿不到锁的情况下，会等待一段时间，直到超时；</p>
</li>
<li data-nodeid="196685">
<p data-nodeid="196686"><strong data-nodeid="196951">LockInterruptibly：</strong> 与 Lock 类似，但是可以锁等待，可以被中断，中断后返回 InterruptedException；</p>
</li>
</ul>
<p data-nodeid="196687">一般情况下，使用 Lock 方法就可以；但如果业务请求要求响应及时，那使用带超时时间的<strong data-nodeid="196957">tryLock</strong>是更好的选择：我们的业务可以直接返回失败，而不用进行阻塞等待。tryLock 这种优化手段，采用降低请求成功率的方式，来保证服务的可用性，在高并发场景下常被高频采用。</p>
<h4 data-nodeid="196688">2.读写锁</h4>
<p data-nodeid="196689">但对于有些业务来说，使用 Lock 这种粗粒度的锁还是太慢了。比如，对于一个HashMap 来说，某个业务是读多写少的场景，这个时候，如果给读操作，也加上和写操作一样的锁的话，效率就会很慢。</p>
<p data-nodeid="196690">ReentrantReadWriteLock 是一种读写分离的锁，它允许多个读线程同时进行，但读和写、写和写是互斥的。</p>
<p data-nodeid="196691">使用方法如下所示，分别获取读写锁，对写操作加写锁，对读操作加读锁，并在 finally 里释放锁即可。</p>
<pre class="lang-java" data-nodeid="196692"><code data-language="java">ReentrantReadWriteLock lock = <span class="hljs-keyword">new</span> ReentrantReadWriteLock();
 &nbsp; &nbsp;Lock readLock = lock.readLock();
 &nbsp; &nbsp;Lock writeLock = lock.writeLock();

 &nbsp; &nbsp;<span class="hljs-function"><span class="hljs-keyword">public</span> <span class="hljs-keyword">void</span> <span class="hljs-title">put</span><span class="hljs-params">(K k, V v)</span> </span>{
 &nbsp; &nbsp; &nbsp; &nbsp;writeLock.lock();
 &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-keyword">try</span> {
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;map.put(k, v);
 &nbsp; &nbsp; &nbsp;  } <span class="hljs-keyword">finally</span> {
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;writeLock.unlock();
 &nbsp; &nbsp; &nbsp;  }
 &nbsp;  }
...
</code></pre>
<p data-nodeid="196693"><strong data-nodeid="196965">这里留一个课后作业：除了 ReadWriteLock，我们能有更快的读写分离模式吗？JDK 1.8 加入了哪个 API？（欢迎你在留言区作答，我将与你们一一交流）</strong></p>
<h4 data-nodeid="196694">3.公平锁与非公平锁</h4>
<ul data-nodeid="196695">
<li data-nodeid="196696">
<p data-nodeid="196697"><strong data-nodeid="196970">非公平锁</strong></p>
</li>
</ul>
<p data-nodeid="196698">我们平常用到的锁，都是非公平锁，可以回过头来看一下 monitor 的原理。当持有锁的线程释放锁的时候，EntrySet 里的线程就会争抢这把锁，这个争抢过程，是随机的，也就是说你并不知道哪个线程会获取对象锁，谁抢到了就算谁的。</p>
<p data-nodeid="196699">这就有一定的概率会发生，某个线程总是抢不到锁的情况。比如，某个线程通过 setPriority 设置得比较低的优先级，这个抢不到锁的线程，就一直处于饥饿状态，这就是<strong data-nodeid="196977">线程饥饿</strong>的概念。</p>
<ul data-nodeid="196700">
<li data-nodeid="196701">
<p data-nodeid="196702"><strong data-nodeid="196981">公平锁</strong></p>
</li>
</ul>
<p data-nodeid="196703">而公平锁通过把随机变成有序，可以解决这个问题，synchronized 没有这个功能，在Lock 中可以通过构造参数设置成公平锁，代码如下：</p>
<pre class="lang-java" data-nodeid="196704"><code data-language="java"><span class="hljs-function"><span class="hljs-keyword">public</span> <span class="hljs-title">ReentrantReadWriteLock</span><span class="hljs-params">(<span class="hljs-keyword">boolean</span> fair)</span> </span>{
 &nbsp; &nbsp; &nbsp; &nbsp;sync = fair ? <span class="hljs-keyword">new</span> FairSync() : <span class="hljs-keyword">new</span> NonfairSync();
 &nbsp; &nbsp; &nbsp; &nbsp;readerLock = <span class="hljs-keyword">new</span> ReadLock(<span class="hljs-keyword">this</span>);
 &nbsp; &nbsp; &nbsp; &nbsp;writerLock = <span class="hljs-keyword">new</span> WriteLock(<span class="hljs-keyword">this</span>);
}
</code></pre>
<p data-nodeid="196705">由于所有的线程都需要排队，需要在多核的场景下维护一个同步队列，在多个线程争抢锁的时候，吞吐量就很低。</p>
<p data-nodeid="196706">下面是 20 个并发之下，锁的 JMH 测试结果，可以看到，<strong data-nodeid="196988">非公平锁比公平锁的性能高出两个数量级。</strong></p>
<pre class="lang-java" data-nodeid="196707"><code data-language="java">Benchmark &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;  Mode  Cnt &nbsp; &nbsp;  Score &nbsp; &nbsp;  Error &nbsp; Units
FairVSNoFairBenchmark.fair &nbsp;  thrpt &nbsp; <span class="hljs-number">10</span> &nbsp; &nbsp;<span class="hljs-number">186.144</span> ± &nbsp; <span class="hljs-number">27.462</span>  ops/ms
FairVSNoFairBenchmark.nofair  thrpt &nbsp; <span class="hljs-number">10</span> &nbsp;<span class="hljs-number">35195.649</span> ± <span class="hljs-number">6503.375</span>  ops/ms
</code></pre>
<h3 data-nodeid="196708">锁的优化技巧</h3>
<h4 data-nodeid="196709">1.死锁</h4>
<p data-nodeid="196710">我们可以先看一下锁冲突最严重的一种情况：死锁。下面这段示例代码，两个线程分别持有对方所需要的锁，并进入了相互等待的状态，那么它们就进入了死锁。</p>
<p data-nodeid="196711">在面试中，经常会要求被面试者手写下面这段代码：</p>
<pre class="lang-java" data-nodeid="196712"><code data-language="java"><span class="hljs-keyword">public</span> <span class="hljs-class"><span class="hljs-keyword">class</span> <span class="hljs-title">DeadLockDemo</span> </span>{
 &nbsp; &nbsp;<span class="hljs-function"><span class="hljs-keyword">public</span> <span class="hljs-keyword">static</span> <span class="hljs-keyword">void</span> <span class="hljs-title">main</span><span class="hljs-params">(String[] args)</span> </span>{
 &nbsp; &nbsp; &nbsp; &nbsp;Object object1 = <span class="hljs-keyword">new</span> Object();
 &nbsp; &nbsp; &nbsp; &nbsp;Object object2 = <span class="hljs-keyword">new</span> Object();
 &nbsp; &nbsp; &nbsp; &nbsp;Thread t1 = <span class="hljs-keyword">new</span> Thread(() -&gt; {
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-keyword">synchronized</span> (object1) {
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-keyword">try</span> {
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Thread.sleep(<span class="hljs-number">200</span>);
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;  } <span class="hljs-keyword">catch</span> (InterruptedException e) {
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;e.printStackTrace();
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;  }
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-keyword">synchronized</span> (object2) {
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;  }
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;  }
 &nbsp; &nbsp; &nbsp;  }, <span class="hljs-string">"deadlock-demo-1"</span>);

 &nbsp; &nbsp; &nbsp; &nbsp;t1.start();
 &nbsp; &nbsp; &nbsp; &nbsp;Thread t2 = <span class="hljs-keyword">new</span> Thread(() -&gt; {
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-keyword">synchronized</span> (object2) {
                <span class="hljs-keyword">try</span> {
                    Thread.sleep(<span class="hljs-number">200</span>);
                } <span class="hljs-keyword">catch</span> (InterruptedException e) {
                    e.printStackTrace();
                }
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-keyword">synchronized</span> (object1) {
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;  }
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;  }
 &nbsp; &nbsp; &nbsp;  }, <span class="hljs-string">"deadlock-demo-2"</span>);
 &nbsp; &nbsp; &nbsp; &nbsp;t2.start();
 &nbsp;  }
}
</code></pre>
<p data-nodeid="196713">代码创建了两把对象锁，线程1 首先拿到了 object1 的对象锁，200ms 后尝试获取 object2 的对象锁。但这个时候，object2 的对象锁已经被线程2 获取了。这两个线程进入了相互等待的状态，产生了死锁。</p>
<p data-nodeid="196714">使用我们上面提到的，带超时时间的 tryLock 方法，有一方超时让步，可以一定程度上避免死锁。</p>
<h4 data-nodeid="196715">2.优化技巧</h4>
<p data-nodeid="196716">锁的优化理论其实很简单，那就是<strong data-nodeid="197005">减少锁的冲突</strong>。无论是锁的读写分离，还是分段锁，本质上都是为了<strong data-nodeid="197006">避免多个线程同时获取同一把锁</strong>。</p>
<p data-nodeid="196717">所以我们可以总结一下优化的一般思路：减少锁的粒度、减少锁持有的时间、锁分级、锁分离 、锁消除、乐观锁、无锁等。</p>
<p data-nodeid="203484"><img src="https://s0.lgstatic.com/i/image/M00/45/DE/Ciqc1F9DmBqAEgcKAABk33fmf4k676.png" alt="3.png" data-nodeid="203487"></p>


<ul data-nodeid="202003">
<li data-nodeid="202004">
<p data-nodeid="202005"><strong data-nodeid="202012">减少锁粒度</strong></p>
</li>
</ul>


<p data-nodeid="196722">通过减小锁的粒度，可以将冲突分散，减少冲突的可能，从而提高并发量。简单来说，就是把资源进行抽象，针对每类资源<strong data-nodeid="197020">使用单独的锁进行保护</strong>。</p>
<p data-nodeid="196723">比如下面的代码，由于 list 1 和 list 2 属于两类资源，就没必要使用同一个对象锁进行处理。</p>
<pre class="lang-java" data-nodeid="196724"><code data-language="java"><span class="hljs-keyword">public</span> <span class="hljs-class"><span class="hljs-keyword">class</span> <span class="hljs-title">LockLessDemo</span> </span>{
 &nbsp; &nbsp;List&lt;String&gt; list1 = <span class="hljs-keyword">new</span> ArrayList&lt;&gt;();
 &nbsp; &nbsp;List&lt;String&gt; list2 = <span class="hljs-keyword">new</span> ArrayList&lt;&gt;();
 &nbsp; &nbsp;<span class="hljs-function"><span class="hljs-keyword">public</span> <span class="hljs-keyword">synchronized</span> <span class="hljs-keyword">void</span> <span class="hljs-title">addList1</span><span class="hljs-params">(String v)</span></span>{
 &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-keyword">this</span>.list1.add(v);
 &nbsp;  }
 &nbsp; &nbsp;<span class="hljs-function"><span class="hljs-keyword">public</span> <span class="hljs-keyword">synchronized</span> <span class="hljs-keyword">void</span> <span class="hljs-title">addList2</span><span class="hljs-params">(String v)</span></span>{
 &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-keyword">this</span>.list2.add(v);
 &nbsp;  }
}
</code></pre>
<p data-nodeid="196725">可以创建两个不同的锁，改善情况如下：</p>
<pre class="lang-java" data-nodeid="196726"><code data-language="java"><span class="hljs-keyword">public</span> <span class="hljs-class"><span class="hljs-keyword">class</span> <span class="hljs-title">LockLessDemo</span> </span>{
 &nbsp; &nbsp;List&lt;String&gt; list1 = <span class="hljs-keyword">new</span> ArrayList&lt;&gt;();
 &nbsp; &nbsp;List&lt;String&gt; list2 = <span class="hljs-keyword">new</span> ArrayList&lt;&gt;();
 &nbsp; &nbsp;<span class="hljs-keyword">final</span> Object lock1 = <span class="hljs-keyword">new</span> Object();
 &nbsp; &nbsp;<span class="hljs-keyword">final</span> Object lock2 = <span class="hljs-keyword">new</span> Object();
 &nbsp; &nbsp;<span class="hljs-function"><span class="hljs-keyword">public</span> <span class="hljs-keyword">void</span> <span class="hljs-title">addList1</span><span class="hljs-params">(String v)</span> </span>{
 &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-keyword">synchronized</span> (lock1) {
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-keyword">this</span>.list1.add(v);
 &nbsp; &nbsp; &nbsp;  }
 &nbsp;  }
 &nbsp; &nbsp;<span class="hljs-function"><span class="hljs-keyword">public</span> <span class="hljs-keyword">void</span> <span class="hljs-title">addList2</span><span class="hljs-params">(String v)</span> </span>{
 &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-keyword">synchronized</span> (lock2) {
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-keyword">this</span>.list2.add(v);
 &nbsp; &nbsp; &nbsp;  }
 &nbsp;  }
}
</code></pre>
<ul data-nodeid="196727">
<li data-nodeid="196728">
<p data-nodeid="196729"><strong data-nodeid="197026">减少锁持有时间</strong></p>
</li>
</ul>
<p data-nodeid="196730">通过让锁资源尽快地释放，减少锁持有的时间，其他线程可更迅速地获取锁资源，进行其他业务的处理。</p>
<p data-nodeid="196731">考虑到下面的代码，由于 slowMethod 不在锁的范围内，占用的时间又比较长，可以把它移动到 Synchronized 代码块外面，加速锁的释放。</p>
<pre class="lang-java" data-nodeid="196732"><code data-language="java"><span class="hljs-keyword">public</span> <span class="hljs-class"><span class="hljs-keyword">class</span> <span class="hljs-title">LockTimeDemo</span> </span>{
 &nbsp; &nbsp;List&lt;String&gt; list = <span class="hljs-keyword">new</span> ArrayList&lt;&gt;();
 &nbsp; &nbsp;<span class="hljs-keyword">final</span> Object lock = <span class="hljs-keyword">new</span> Object();
 &nbsp; &nbsp;<span class="hljs-function"><span class="hljs-keyword">public</span> <span class="hljs-keyword">void</span> <span class="hljs-title">addList</span><span class="hljs-params">(String v)</span> </span>{
 &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-keyword">synchronized</span> (lock) {
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;slowMethod();
 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<span class="hljs-keyword">this</span>.list.add(v);
 &nbsp; &nbsp; &nbsp;  }
 &nbsp;  }
 &nbsp; &nbsp;<span class="hljs-function"><span class="hljs-keyword">public</span> <span class="hljs-keyword">void</span> <span class="hljs-title">slowMethod</span><span class="hljs-params">()</span></span>{
 &nbsp;  }
}
</code></pre>
<ul data-nodeid="196733">
<li data-nodeid="196734">
<p data-nodeid="196735"><strong data-nodeid="197032">锁分级</strong></p>
</li>
</ul>
<p data-nodeid="196736">锁分级，指的是我们文章开始讲解的 Synchronied 锁的锁升级，属于 JVM 的内部优化，它从偏向锁开始，逐渐升级为轻量级锁、重量级锁，这个过程是不可逆的。</p>
<ul data-nodeid="196737">
<li data-nodeid="196738">
<p data-nodeid="196739"><strong data-nodeid="197037">锁分离</strong></p>
</li>
</ul>
<p data-nodeid="196740">我们在上面提到的读写锁，就是锁分离技术。这是因为，读操作一般是不会对资源产生影响的，可以并发执行；写操作和其他操作是互斥的，只能排队执行。所以读写锁适合读多写少的场景。</p>
<ul data-nodeid="196741">
<li data-nodeid="196742">
<p data-nodeid="196743"><strong data-nodeid="197042">锁消除</strong></p>
</li>
</ul>
<p data-nodeid="196744">通过 JIT 编译器，JVM 可以消除某些对象的加锁操作。举个例子，大家都知道StringBuffer 和 StringBuilder 都是做字符串拼接的，而且前者是线程安全的。</p>
<p data-nodeid="196745">但其实，如果这两个字符串拼接对象用在函数内，JVM 通过逃逸分析这个对象的作用范围就是在本函数中，就会把锁的影响给消除掉。</p>
<p data-nodeid="196746">比如下面这段代码，它和 StringBuilder 的效果是一样的。</p>
<pre class="lang-java" data-nodeid="196747"><code data-language="java"><span class="hljs-function">String <span class="hljs-title">m1</span><span class="hljs-params">()</span></span>{
 &nbsp; &nbsp;StringBuffer sb = <span class="hljs-keyword">new</span> StringBuffer();
 &nbsp; &nbsp;sb.append(<span class="hljs-string">""</span>);
 &nbsp; &nbsp;<span class="hljs-keyword">return</span> sb.toString();
}
</code></pre>
<p data-nodeid="196748">当然，对于读多写少的互联网场景，最有效的做法，是使用乐观锁，甚至无锁，这部分我们会在下一课时《14 | 案例分析：乐观锁和无锁》中介绍。</p>
<h3 data-nodeid="196749">小结</h3>
<p data-nodeid="196750">Java 中有两种加锁方式：一种是使用 Synchronized 关键字，另外一种是 concurrent 包下面的 Lock。</p>
<p data-nodeid="196751">本课时，我们详细地了解了它们的一些特性，包括实现原理，其对比如下：</p>
<table data-nodeid="196753">
<thead data-nodeid="196754">
<tr data-nodeid="196755">
<th align="center" data-org-content="**类别**" data-nodeid="196757"><strong data-nodeid="197055">类别</strong></th>
<th data-org-content="**Synchronized**" data-nodeid="196758"><strong data-nodeid="197059">Synchronized</strong></th>
<th align="center" data-org-content="**Lock**" data-nodeid="196759"><strong data-nodeid="197063">Lock</strong></th>
</tr>
</thead>
<tbody data-nodeid="196763">
<tr data-nodeid="196764">
<td align="center" data-org-content="实现方式" data-nodeid="196765">实现方式</td>
<td data-org-content="monitor" data-nodeid="196766">monitor</td>
<td align="center" data-org-content="AQS" data-nodeid="196767">AQS</td>
</tr>
<tr data-nodeid="196768">
<td align="center" data-org-content="底层细节" data-nodeid="196769">底层细节</td>
<td data-org-content="JVM优化" data-nodeid="196770">JVM优化</td>
<td align="center" data-org-content="Java API" data-nodeid="196771">Java API</td>
</tr>
<tr data-nodeid="196772">
<td align="center" data-org-content="分级锁" data-nodeid="196773">分级锁</td>
<td data-org-content="是" data-nodeid="196774">是</td>
<td align="center" data-org-content="否" data-nodeid="196775">否</td>
</tr>
<tr data-nodeid="196776">
<td align="center" data-org-content="功能特性" data-nodeid="196777">功能特性</td>
<td data-org-content="单一" data-nodeid="196778">单一</td>
<td align="center" data-org-content="丰富" data-nodeid="196779">丰富</td>
</tr>
<tr data-nodeid="196780">
<td align="center" data-org-content="锁分离" data-nodeid="196781">锁分离</td>
<td data-org-content="无" data-nodeid="196782">无</td>
<td align="center" data-org-content="读写锁" data-nodeid="196783">读写锁</td>
</tr>
<tr data-nodeid="196784">
<td align="center" data-org-content="锁超时" data-nodeid="196785">锁超时</td>
<td data-org-content="无" data-nodeid="196786">无</td>
<td align="center" data-org-content="带超时时间的 tryLock" data-nodeid="196787">带超时时间的 tryLock</td>
</tr>
<tr data-nodeid="196788">
<td align="center" data-org-content="可中断" data-nodeid="196789">可中断</td>
<td data-org-content="否" data-nodeid="196790">否</td>
<td align="center" data-org-content="lockInterruptibly" data-nodeid="196791">lockInterruptibly</td>
</tr>
</tbody>
</table>
<p data-nodeid="196792">Lock 的功能是比 Synchronized 多的，能够对线程行为进行更细粒度的控制。</p>
<p data-nodeid="196793">但如果只是用最简单的锁互斥功能，建议直接使用 Synchronized，有两个原因：</p>
<ul data-nodeid="196794">
<li data-nodeid="196795">
<p data-nodeid="196796">Synchronized 的编程模型更加简单，更易于使用</p>
</li>
<li data-nodeid="196797">
<p data-nodeid="196798">Synchronized 引入了偏向锁，轻量级锁等功能，能够从 JVM 层进行优化，同时JIT 编译器也会对它执行一些锁消除动作。</p>
</li>
</ul>
<p data-nodeid="196799" class="">我们还了解了公平锁与非公平锁，以及可重入锁的概念，以及一些通用的优化技巧。有冲突，才会有优化空间，那么无锁队列是怎么回事呢？它又是怎么实现的呢？下一课时《14 | 案例分析：乐观锁和无锁》，我们会来解答这些问题。</p>

---

### 精选评论

##### **风：
> JDK1.8 加了一个StampedLock，具体的不同在于提供了乐观锁1.获取乐观读锁(会获取一个校验码)2.读取一些值3.根据步骤1的校验码再次校验，看看是否有被动过4.如果没有被动过就结束了4.如果被动过，转为读锁(接下来就和readwritelock一致了)

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 总结的很好，加油

##### **威：
> 清晰又有深度 牛逼

##### **6114：
> CopyOnWrite容器 也算是一种锁的优化吧（只是一个局部的优化，但是在我们使用资源，尤其是缓存的资源使用时，可以去掉锁的使用了）。

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 可以这么理解，是对于读多写少场景的优化；如果是写多读少，这种优化的效果就是反向的

##### **耀：
> Markword是24位？

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; markword的定义文件见：http://hg.openjdk.java.net/jdk8/jdk8/hotspot/file/87ee5ee27509/src/share/vm/oops/markOop.hpp

32位系统：长度32bit 4byte
64位系统：长度64bit 8byte，但是由于压缩指针的存在，也有可能是32Bit （UseCompressedOops）

##### Albert：
> 老师，锁好像可以在gc安全点降级

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 降级这个概念有点模糊，效率也不高，可以参考一下 http://openjdk.java.net/jeps/8183909

##### **升：
> 对象头mark word里面age应该是4个bit吧？

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 你说的对。具体大小如下：

//  32 bits:
//  --------
//             hash:25 ------------>| age:4    biased_lock:1 lock:2 (normal object)
//             JavaThread*:23 epoch:2 age:4    biased_lock:1 lock:2 (biased object)
//             size:32 ------------------------------------------>| (CMS free block)
//             PromotedObject*:29 ---------->| promo_bits:3 ----->| (CMS promoted object)
//
//  64 bits:
//  --------
//  unused:25 hash:31 -->| unused:1   age:4    biased_lock:1 lock:2 (normal object)
//  JavaThread*:54 epoch:2 unused:1   age:4    biased_lock:1 lock:2 (biased object)
//  PromotedObject*:61 --------------------->| promo_bits:3 ----->| (CMS promoted object)
//  size:64 ----------------------------------------------------->| (CMS free block)
//
//  unused:25 hash:31 -->| cms_free:1 age:4    biased_lock:1 lock:2 (COOPs && normal object)
//  JavaThread*:54 epoch:2 cms_free:1 age:4    biased_lock:1 lock:2 (COOPs && biased object)
//  narrowOop:32 unused:24 cms_free:1 unused:4 promo_bits:3 ----->| (COOPs && CMS promoted object)
//  unused:21 size:35 -->| cms_free:1 unused:7 ------------------>| (COOPs && CMS free block)

##### **青：
> Stamplock

